/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.easymagic.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.EnchantmentScreen;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EnchantmentInventoryScreen
extends EnchantmentScreen {
    private final List<List<ITextComponent>> slotTooltips = IntStream.range(0, 3).mapToObj(i -> Lists.newArrayList()).collect(Collectors.toList());

    public EnchantmentInventoryScreen(EnchantmentContainer container, PlayerInventory playerInventory, ITextComponent textComponent) {
        super(container, playerInventory, textComponent);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int slot;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.showAllEnchantments() && (slot = this.getEnchantingSlot(mouseX, mouseY)) != -1 && !this.slotTooltips.get(slot).isEmpty()) {
            this.func_243308_b(matrixStack, this.slotTooltips.get(slot), mouseX, mouseY);
        }
    }

    protected boolean func_195359_a(int x, int y, int width, int height, double mouseX, double mouseY) {
        if (!this.showAllEnchantments() || this.getSelectedSlot(mouseX, mouseY) != null) {
            return super.func_195359_a(x, y, width, height, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private Slot getSelectedSlot(double mouseX, double mouseY) {
        for (int i = 0; i < ((EnchantmentContainer)this.field_147002_h).field_75151_b.size(); ++i) {
            Slot slot = (Slot)((EnchantmentContainer)this.field_147002_h).field_75151_b.get(i);
            if (!this.isSlotSelected(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    private boolean isSlotSelected(Slot slotIn, double mouseX, double mouseY) {
        return super.func_195359_a(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    private boolean showAllEnchantments() {
        return this.slotTooltips.stream().mapToInt(List::size).sum() > 0;
    }

    private int getEnchantingSlot(int mouseX, int mouseY) {
        for (int j = 0; j < 3; ++j) {
            int levels = ((EnchantmentContainer)this.field_147002_h).field_75167_g[j];
            if (!super.func_195359_a(60, 14 + 19 * j, 108, 17, (double)mouseX, (double)mouseY) || levels <= 0) continue;
            return j;
        }
        return -1;
    }

    public void setSlotTooltip(int slot, List<EnchantmentData> slotData) {
        List<ITextComponent> slotTooltip = this.slotTooltips.get(slot);
        slotTooltip.clear();
        this.addSlotEnchantments(slot, slotData, slotTooltip);
    }

    private void addSlotEnchantments(int slot, List<EnchantmentData> slotData, List<ITextComponent> slotTooltip) {
        boolean isEnchantmentPresent = false;
        for (EnchantmentData data : slotData) {
            slotTooltip.add((ITextComponent)new TranslationTextComponent("container.enchant.clue", new Object[]{data.field_76302_b == null ? "" : data.field_76302_b.func_200305_d(data.field_76303_c)}).func_240699_a_(TextFormatting.WHITE));
            if (data.field_76302_b == null) continue;
            isEnchantmentPresent = true;
        }
        this.addSlotInfo(slot, slotTooltip, isEnchantmentPresent);
    }

    private void addSlotInfo(int slot, List<ITextComponent> slotTooltip, boolean isEnchantmentPresent) {
        if (!isEnchantmentPresent) {
            slotTooltip.add(StringTextComponent.field_240750_d_);
            slotTooltip.add((ITextComponent)new TranslationTextComponent("forge.container.enchant.limitedEnchantability").func_240699_a_(TextFormatting.RED));
        } else if (!this.field_230706_i_.field_71439_g.field_71075_bZ.field_75098_d) {
            slotTooltip.add(StringTextComponent.field_240750_d_);
            int enchantLevels = ((EnchantmentContainer)this.field_147002_h).field_75167_g[slot];
            if (this.field_230706_i_.field_71439_g.field_71068_ca < enchantLevels) {
                slotTooltip.add((ITextComponent)new TranslationTextComponent("container.enchant.level.requirement", new Object[]{enchantLevels}).func_240699_a_(TextFormatting.RED));
            } else {
                this.addLapisComponent(++slot, slotTooltip);
                this.addLevelComponent(slot, slotTooltip);
            }
        }
    }

    private void addLapisComponent(int slot, List<ITextComponent> slotTooltip) {
        TranslationTextComponent lapisComponent = slot == 1 ? new TranslationTextComponent("container.enchant.lapis.one") : new TranslationTextComponent("container.enchant.lapis.many", new Object[]{slot});
        slotTooltip.add((ITextComponent)lapisComponent.func_240699_a_(((EnchantmentContainer)this.field_147002_h).func_178147_e() >= slot ? TextFormatting.GRAY : TextFormatting.RED));
    }

    private void addLevelComponent(int slot, List<ITextComponent> slotTooltip) {
        TranslationTextComponent levelComponent = slot == 1 ? new TranslationTextComponent("container.enchant.level.one") : new TranslationTextComponent("container.enchant.level.many", new Object[]{slot});
        slotTooltip.add((ITextComponent)levelComponent.func_240699_a_(TextFormatting.GRAY));
    }
}

